/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.base.VWComponentManager;
import filenet.vw.integrator.base.VWSocketListener;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

class VWEventListener
implements Runnable {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.eventlistener");
    private int port = 0;
    private boolean done = false;
    private VWComponentManager cm = null;
    private Vector socket_listeners = new Vector();
    protected static final String m_className = "VWEventListener";
    private static int NUM_WORKERS = 5;

    public static String _get_FILE_DATE() {
        return "$Date:   14 Aug 2006 18:12:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public VWEventListener(int port, VWComponentManager cm) {
        String m_method = "<init:" + port + ">";
        logger.entering(m_className, m_method);
        this.port = port;
        this.cm = cm;
        logger.exiting(m_className, m_method);
    }

    public void stop() {
        String m_method = "stop";
        logger.entering(m_className, "stop");
        Enumeration elements = this.socket_listeners.elements();
        while (elements.hasMoreElements()) {
            VWSocketListener sl = (VWSocketListener)elements.nextElement();
            sl.killMe();
        }
        this.done = true;
        logger.exiting(m_className, "stop");
    }

    public void run() {
        String m_method = "run";
        logger.entering(m_className, "run");
        try {
            for (int i = 1; i <= NUM_WORKERS; ++i) {
                VWSocketListener sl = new VWSocketListener(this.cm, i);
                sl.start();
                this.socket_listeners.add(sl);
            }
            ServerSocket ss = new ServerSocket(this.port);
            while (!this.done) {
                try {
                    Socket s = ss.accept();
                    VWSocketListener.processRequest(s);
                }
                catch (Exception e) {
                    logger.throwing(m_className, "run", e);
                }
            }
            ss.close();
        }
        catch (Exception e) {
            logger.throwing(m_className, "run", e);
        }
        logger.exiting(m_className, "run");
    }

    static {
        try {
            String s = System.getProperty("filenet.pe.cm.event.listener.workers", "5");
            NUM_WORKERS = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

